#!/bin/bash
##
## ++++++++++++++++++++++++++++++++++++++++
## kernel-remover.sh - vers 1.1, May 2012
## by gerrit (http://www.funzt.info/?p=873)
## ++++++++++++++++++++++++++++++++++++++++
##
## script removing obsolete kernels from Fedora, should work
## on any recent Red Hat based distro: Fedora/RHEL/CentOS
## CAUTION: You should know what you're doing!
##
## Use at your own risk!!
## 
## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
## GNU GENERAL PUBLIC LICENSE
## Version 2, June 1991
##
## Copyright (C) 1989, 1991 Free Software Foundation, Inc.  
## 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
##
## Everyone is permitted to copy and distribute verbatim copies
## of this license document, but changing it is not allowed.
##
## see http://www.gnu.org/licenses/gpl-2.0.html
## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
##


## some variables
COL_BLUE="\x1b[34;01m"
COL_RED="\x1b[31;01m"
COL_RESET="\x1b[39;49;00m"


## say hello
echo -e "\n###########################"
echo -e "** Fedora kernel-remover **"
echo -e "###########################\n"


## checks
echo -ne "Executing some checks ... "
# check root
ID=`whoami`
if [ "${ID}" != "root" ]; then
	echo -e "\nPlease run this script as root.\n"
	exit 1
fi

# check yum
which yum &> /dev/null
RT=$?
if [ "${RT}" != "0" ]; then
	echo -e "\nERROR: could not find 'yum' in your PATH. Exiting now.\n"
	echo -e "Are you sure you are running Fedora/RHEL/CentOS???\n"
	exit 1
fi

# check distro
if [ -f /etc/redhat-release ]; then
	grep -i fedora /etc/redhat-release &> /dev/null
	RT=$?
	if [ "${RT}" != "0" ]; then
		echo -e "\nINFO: You do not seem to be running 'Fedora'. Continuing though...\n"
	fi
else
	echo -e "${COL_RED}WARNING:${COL_RESET} You do not seem to be running a Red Hat based distro!\n"
	if [ "$1" != "-f" ]; then
		echo -e "\nRun this script with '-f' to force. (Not recommended)\n"
		exit 1
	else
		echo -e "\nINFO: Continuing as you've chosen to force with '-f'.\n"
	fi
fi

echo -e "PASSED!\n"


## getting list of kernels
echo -ne "Retrieving list of installed kernel packages, please wait ..."
ARCH=`uname -m`
CURRENT_KERNEL=`uname -r | sed "s/.$ARCH//g"`
KERNELS_INSTALLED=`yum list installed kernel.$(uname -m) | grep ^kernel | awk '{print $2}'`
KERNEL_DEV_INSTALLED=`yum list installed kernel-devel.$(uname -m) | grep ^kernel-devel | awk '{print $2}'`
LIST_INSTALLED_TO_REMOVE=`echo $KERNELS_INSTALLED | sed 's/\ /\n/g' | grep -v $CURRENT_KERNEL`
echo -e " done!"


## do the kernel stuff
# say good bye if only one kernel is present
if [ -z $LIST_INSTALLED_TO_REMOVE ]; then
	echo -e "\nYou have only one kernel installed, nothing to remove.\n"
	echo -e "\n** Finished `basename $0` **\n"
	exit 0
fi

# list/remove kernels
echo -e "\n---------------------------------------------------------------"
echo -e "You have installed the following Fedora kernels on your system:\n"
for i in $KERNELS_INSTALLED; do
	echo -e "$COL_BLUE $i $COL_RESET"
done
echo -e "\nYou are currently running kernel $COL_BLUE$CURRENT_KERNEL$COL_RESET, so you may remove:\n"
for i in $LIST_INSTALLED_TO_REMOVE; do
	echo -e "$COL_RED $i $COL_RESET"
done
echo -e "\nHINT: It is advisable to keep at least two working kernels."
echo -e "You may now select kernels you'd like to remove:"


for i in $LIST_INSTALLED_TO_REMOVE; do
	echo -ne "\nRemove kernel$COL_RED $i $COL_RESET[y|n]? "
	read ANSWER
	case "$ANSWER" in
		"Y" | "y" )
			echo $KERNEL_DEV_INSTALLED | grep $i &> /dev/null
			RT=$?
			if [ "$RT" = 0 ]; then
				echo -e "\nFound$COL_RED kernel-devel-${i}$COL_RESET package and will remove it as well (and all dependencies)...\n"
				yum -y remove kernel-${i}.${ARCH} kernel-devel-${i}.${ARCH}
			else
				echo -e "\nNow removing kernel $COL_RED$i$COL_RESET (and all dependencies)...\n"
				yum -y remove kernel-${i}.${ARCH}
			fi
		;;
		"N" | "n" )
			echo -e "\nKeeping kernel $COL_BLUE$i$COL_RESET."
		;;
		* )
			echo -e "\nPlease answer 'y' or 'n'. Exiting now."
			exit 1
		;;
	esac
done

echo -e "\n** Finished `basename $0` **\n"

